/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.summary;

import filenet.vw.toolkit.runtime.VWTrkMilestone;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.summary.VWMilestoneHistoryTableModel;
import filenet.vw.toolkit.runtime.summary.VWTrackerSummaryInfo;
import filenet.vw.toolkit.runtime.summary.images.VWImageLoader;
import filenet.vw.toolkit.runtime.summary.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWTrackerSummaryCellRenderer;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWMilestoneHistoryTable
extends VWTable
implements MouseListener {
    protected Frame m_parentFrame = null;
    private VWTrackerSummaryInfo m_summaryPanel = null;
    private boolean m_initialized = false;
    private VWMilestoneHistoryTableModel m_tableModel = null;
    protected TableColumnModel m_columnModel = null;
    private JMenuItem m_miDisplayStep = null;
    private VWPopupMenu m_popup = null;
    private ActionListener m_miDisplayStepActionListener = null;
    private int m_popupRow = -1;

    public VWMilestoneHistoryTable(Frame parentFrame, VWTrackerSummaryInfo summaryPanel, VWMilestoneHistoryTableModel tableModel) {
        super(tableModel);
        this.m_parentFrame = parentFrame;
        this.m_summaryPanel = summaryPanel;
        this.m_tableModel = tableModel;
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    private void init() {
        VWTrackerSummaryCellRenderer renderer = new VWTrackerSummaryCellRenderer();
        this.m_columnModel = this.getColumnModel();
        TableColumn reachedColumn = this.m_columnModel.getColumn(0);
        reachedColumn.setMinWidth(20);
        reachedColumn.setMaxWidth(20);
        reachedColumn.setCellRenderer(renderer);
        TableColumn messageColumn = this.m_columnModel.getColumn(4);
        messageColumn.setCellRenderer(renderer);
        messageColumn.setPreferredWidth(200);
        TableColumn levelColumn = this.m_columnModel.getColumn(5);
        levelColumn.setCellRenderer(renderer);
        TableColumn reachedDateColumn = this.m_columnModel.getColumn(6);
        reachedDateColumn.setCellRenderer(renderer);
        this.setShowGrid(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        Font font = this.getFont();
        if (font != null) {
            int width;
            FontMetrics fm = this.getFontMetrics(font);
            if (this.m_tableModel != null) {
                TableColumn nameColumn = this.m_columnModel.getColumn(1);
                nameColumn.setCellRenderer(renderer);
                int width2 = this.getMaxNameWidth(1, fm);
                if (width2 != 0) {
                    nameColumn.setMaxWidth(width2 += 10);
                    nameColumn.setPreferredWidth(width2);
                }
                if ((width2 = this.getMaxDateWidth(6, fm, renderer)) != 0) {
                    reachedDateColumn.setMaxWidth(width2 += 10);
                    reachedDateColumn.setPreferredWidth(width2);
                }
            }
            if ((width = fm.stringWidth(this.m_tableModel.getColumnName(5))) != 0) {
                levelColumn.setMaxWidth(width += 10);
                levelColumn.setPreferredWidth(width);
            }
            TableColumn mapNameColumn = this.m_columnModel.getColumn(2);
            mapNameColumn.setCellRenderer(renderer);
            TableColumn stepNameColumn = this.m_columnModel.getColumn(3);
            stepNameColumn.setCellRenderer(renderer);
            this.adjustMapStepColumnSizes();
        }
        this.m_initialized = true;
        this.addMouseListener(this);
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    private int getMaxNameWidth(int col, FontMetrics fm) {
        if (fm == null) {
            return 0;
        }
        int width = 0;
        if (this.m_tableModel != null) {
            ImageIcon m_expandIcon = VWImageLoader.createImageIcon("expand.gif");
            int iconWidth = m_expandIcon.getIconWidth();
            width = fm.stringWidth(this.m_tableModel.getColumnName(col));
            Vector milestones = this.m_tableModel.getMilestones();
            if (milestones != null) {
                for (int i = 0; i < milestones.size(); ++i) {
                    String s = null;
                    Object obj = milestones.elementAt(i);
                    if (obj == null || !(obj instanceof VWTrkMilestone) || (s = ((VWTrkMilestone)obj).getName()) == null || s.length() <= 0) continue;
                    int w = fm.stringWidth(s);
                    if (((VWTrkMilestone)obj).getHistorySize() > 1) {
                        w += iconWidth;
                    }
                    if (w <= width) continue;
                    width = w;
                }
            }
        }
        return width;
    }

    private int getMaxDateWidth(int col, FontMetrics fm, VWTrackerSummaryCellRenderer renderer) {
        if (fm == null) {
            return 0;
        }
        int width = 0;
        if (this.m_tableModel != null) {
            width = fm.stringWidth(this.m_tableModel.getColumnName(col));
            Vector milestones = this.m_tableModel.getMilestones();
            if (milestones != null) {
                for (int i = 0; i < milestones.size(); ++i) {
                    String s = null;
                    Object obj = milestones.elementAt(i);
                    if (obj == null || !(obj instanceof VWTrkMilestone)) continue;
                    VWTrkMilestone milestone = (VWTrkMilestone)obj;
                    int count = milestone.getHistorySize();
                    for (int j = 0; j < count; ++j) {
                        int w;
                        Date date = milestone.getDate(j);
                        if (date != null) {
                            s = VWTrackerSummaryCellRenderer.toString(date);
                        }
                        if (s == null || s.length() <= 0 || (w = fm.stringWidth(s)) <= width) continue;
                        width = w;
                    }
                }
            }
        }
        return width;
    }

    private int getMaxMapNameWidth(FontMetrics fm) {
        if (fm == null) {
            return 0;
        }
        int width = fm.stringWidth(this.m_tableModel.getColumnName(2));
        if (this.m_tableModel != null) {
            String mapName = null;
            for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
                int w;
                Object obj = this.m_tableModel.getValueAt(i, 2);
                if (obj == null || !(obj instanceof String) || (mapName = (String)obj) == null || mapName.length() <= 0 || (w = fm.stringWidth(mapName)) <= width) continue;
                width = w;
            }
        }
        return width;
    }

    private int getMaxStepNameWidth(FontMetrics fm) {
        if (fm == null) {
            return 0;
        }
        int width = fm.stringWidth(this.m_tableModel.getColumnName(3));
        if (this.m_tableModel != null) {
            String stepName = null;
            for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
                int w;
                Object obj = this.m_tableModel.getValueAt(i, 3);
                if (obj == null || !(obj instanceof String) || (stepName = (String)obj) == null || stepName.length() <= 0 || (w = fm.stringWidth(stepName)) <= width) continue;
                width = w;
            }
        }
        return width;
    }

    private void adjustMapStepColumnSizes() {
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fm = this.getFontMetrics(font);
            if (this.m_columnModel != null) {
                TableColumn mapNameColumn = this.m_columnModel.getColumn(2);
                int width = this.getMaxMapNameWidth(fm);
                if (width != 0) {
                    mapNameColumn.setMaxWidth(width += 10);
                    mapNameColumn.setPreferredWidth(width);
                }
                TableColumn stepNameColumn = this.m_columnModel.getColumn(3);
                width = this.getMaxStepNameWidth(fm);
                if (width != 0) {
                    stepNameColumn.setMaxWidth(width += 10);
                    stepNameColumn.setPreferredWidth(width);
                }
            }
        }
    }

    private int getMaxColumnWidth(int col, FontMetrics fm, VWTrackerSummaryCellRenderer renderer) {
        if (fm == null) {
            return 0;
        }
        int width = 0;
        if (this.m_tableModel != null) {
            width = fm.stringWidth(this.m_tableModel.getColumnName(col));
            for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
                int w;
                String s = null;
                Object obj = this.m_tableModel.getValueAt(i, col);
                if (obj == null) continue;
                if (obj instanceof String) {
                    s = (String)obj;
                } else if (renderer != null) {
                    s = VWTrackerSummaryCellRenderer.toString(obj);
                }
                if (s == null || s.length() <= 0 || (w = fm.stringWidth(s)) <= width) continue;
                width = w;
            }
        }
        return width;
    }

    public void tableChanged(TableModelEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_tableModel) {
            this.adjustMapStepColumnSizes();
        }
        super.tableChanged(e);
    }

    public void createPopup(MouseEvent evt) {
        Object source = evt.getSource();
        if (source != this) {
            return;
        }
        Point point = evt.getPoint();
        int row = this.rowAtPoint(point);
        int col = this.columnAtPoint(point);
        if (row == -1 || col == -1) {
            return;
        }
        if (!this.isRowSelected(row)) {
            this.setRowSelectionInterval(row, row);
        }
        this.m_popupRow = row;
        if (this.m_tableModel == null) {
            return;
        }
        VWTrkStep step = this.m_tableModel.getStep(this.m_popupRow);
        if (step == null) {
            return;
        }
        if (this.m_popup == null) {
            this.m_popup = new VWPopupMenu();
        } else {
            this.m_popup.removeAll();
        }
        if (this.m_miDisplayStep == null) {
            this.m_miDisplayStep = new JMenuItem(VWResource.s_displayStep);
            this.m_miDisplayStepActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (VWMilestoneHistoryTable.this.m_tableModel == null) {
                        return;
                    }
                    VWTrkStep step = VWMilestoneHistoryTable.this.m_tableModel.getStep(VWMilestoneHistoryTable.this.m_popupRow);
                    if (step != null && VWMilestoneHistoryTable.this.m_summaryPanel != null) {
                        VWMilestoneHistoryTable.this.m_summaryPanel.displayStep(step, true);
                    }
                }
            };
            this.m_miDisplayStep.addActionListener(this.m_miDisplayStepActionListener);
        }
        this.m_popup.add(this.m_miDisplayStep);
        this.m_popup.show(this, point.x, point.y);
    }

    public void mouseClicked(MouseEvent event) {
        if (!this.m_initialized) {
            return;
        }
        if (event.getSource() != this) {
            return;
        }
        if (event.getClickCount() == 2) {
            Point point = event.getPoint();
            int row = this.rowAtPoint(point);
            int col = this.columnAtPoint(point);
            if (row == -1 || col == -1) {
                return;
            }
            VWTrkStep step = this.m_tableModel.getStep(row);
            if (step != null && this.m_summaryPanel != null) {
                this.m_summaryPanel.displayStep(step, true);
            }
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.createPopup(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.createPopup(event);
        }
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_summaryPanel = null;
        this.removeMouseListener(this);
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            this.m_popup = null;
        }
        if (this.m_miDisplayStep != null) {
            this.m_miDisplayStep.removeActionListener(this.m_miDisplayStepActionListener);
            this.m_miDisplayStep = null;
        }
        this.m_miDisplayStepActionListener = null;
        for (int i = 0; i < this.m_columnModel.getColumnCount(); ++i) {
            this.m_columnModel.getColumn(i).setCellRenderer(null);
        }
        this.m_tableModel = null;
        this.m_columnModel = null;
        super.removeReferences();
    }
}

